/*-----------------------------------------------------------------------------
 * EcOsPlatform.h           platform header file for Windows CE
 * Copyright                acontis technologies GmbH, Weingarten, Germany
 * Response                 Stefan Zintgraf
 * Description
 *---------------------------------------------------------------------------*/

#ifndef INC_ECOSPLATFORM
#define INC_ECOSPLATFORM

/*-INCLUDES------------------------------------------------------------------*/
#include <assert.h>
/* #include <CeLog.h> */
#include "EcType.h"
#include "rX_Includes.h"

#include "AP_Mtx.h"

#include <stdio.h>
#include <stdlib.h>
//#include <stdint.h>
#include <stdarg.h>

/*-COMPILER SETTINGS---------------------------------------------------------*/
#define ATECAT_API

#ifdef ARM
#define WITHALIGNMENT
#else
#undef WITHALIGNMENT
#endif

/*#define DO_LOCKDBG*/
#define USE_LIBC_MALLOC

/*-TYPEDEFS------------------------------------------------------------------*/
typedef struct _OS_LOCK_DESC
{
    RX_HANDLE           rxHandle;
    char                szName[16];
#ifdef DEBUG
    int                 nLockCnt;   
#endif
} OS_LOCK_DESC;

typedef unsigned long long  EC_T_UINT64;
typedef signed long long    EC_T_INT64;
typedef __VALIST            EC_T_VALIST;

typedef struct _OS_INIT_DESC
{
    EC_T_DWORD      dwTimerPriority;
    EC_T_PVOID      pvBecFile;
    EC_T_DWORD      dwBecFileLen;
} OS_INIT_DESC;

/*-MACROS--------------------------------------------------------------------*/
/* define here if tracing shall be enabled in Release mode */
/* #define DEBUGTRACE */
#ifdef DEBUG
#define DEBUGTRACE
#endif

#ifndef EC_VASTART                              
#define EC_VASTART  va_start
#endif

#ifndef EC_VAEND
#define EC_VAEND    va_end
#endif

#ifndef EC_VAARG
#define EC_VAARG    va_arg
#endif

#define EC_INLINEATTRIBUTE  __attribute__ ((always_inline))

/* bloody ## needs a param before issuing string so "generate" one */
#define EC_INLINEINT(dummi, functiondecl)     \
    __inline dummi ##functiondecl EC_INLINEATTRIBUTE; \
    __inline dummi ##functiondecl

#define EC_INLINE(funcdecl) static EC_INLINEINT(,funcdecl)


/* use macros for the most important OS layer routines */
#ifdef USE_LIBC_MALLOC
#define OsMalloc(nSize)                         malloc((size_t)(nSize))
#define OsRealloc(pMem,nSize)                   realloc((void*)(pMem),(size_t)(nSize))
#define OsFree(pMem)                            free((void*)(pMem))
#else
/*#define OsMalloc(nSize)                         rX_MemAllocateMemory((size_t)(nSize))*/
/*#define OsRealloc(pMem,nSize)                   realloc((void*)(pMem),(size_t)(nSize))*/
#define OsFree(pMem)                            rX_MemFreeMemory((void*)(pMem))
#endif

#define OsMemset(pDest,nVal,nSize)              memset((void*)pDest,(int)nVal,(size_t)(nSize))
/*#define OsMemset(pDest,nVal,nSize)              {EC_T_INT n=0;for(n=0; n < (EC_T_INT)(nSize); n++) ((EC_T_PBYTE)(pDest))[n]=(nVal); };*/
//#define OsMemcpy(pDest,pSrc,nSize)              memcpy((void*)(pDest),(const void*)(pSrc),(size_t)(nSize))
//#define OsMemcpy(pDest,pSrc,nSize)              rX_BasMemCpyFast((void*)(pDest),(const void*)(pSrc),(size_t)(nSize))
#define OsMemcpy(pDest,pSrc,nSize)              asm_memcpy((void*)(pDest),(const void*)(pSrc),(size_t)(nSize))

#define OsMemcmp(pBuf1,pBuf2,nSize)             memcmp((void*)(pBuf1),(const void*)(pBuf2),(size_t)(nSize))
#define OsMemmove(pDest,pSrc,nSize)             memmove((void*)(pDest),(const void*)(pSrc),(size_t)(nSize))
#define OsStrlen(szString)                      strlen((const char*)(szString))
#define OsStrcpy(szDest,szSrc)                  strcpy((char*)(szDest),(const char*)(szSrc))
#define OsStrncpy(szDest,szSrc,nSize)           strncpy((char*)(szDest),(const char*)(szSrc),(size_t)nSize)
#define OsStrcmp(szStr1,szStr2)                 strcmp((const char*)szStr1,(const char*)szStr2)
#define OsStrtok(szToken,szDelimit)             strtok((char*)(szToken), (const char*)(szDelimit))
#define OsAtoi(szString)                        atoi((const char*)szString)
#define OsStrtoul(szString,ptr,base)            strtoul((const char*)szString, ptr, base)
/*#define OsVsnprintf(szMsg,nLen,szFormat,vaArgs) vsnprintf(szMsg,nLen,szFormat,vaArgs)*/

#define OsVsnprintf                             EcVsnprintf
#define OsSnprintf                              EcSnprintf

#define OsSleep(dwMsec)                         rX_SysSleepTask( (EC_T_DWORD)((((EC_T_DWORD)dwMsec)*1000)/rX_SysGetSystemCycletime()) )
#if (defined DEBUG) || (defined RELASSERT)
#define OsDbgAssert(term)                       if( !(term) ) {printf("Assertion raised <term> (%s): %s:%d\n", __FUNCTION__, __FILE__, __LINE__);for(;;){OsSleep(1000);};}
#else
#define OsDbgAssert(term)
#endif

/*#define OsSetEvent(hEvent)                      SetEvent((HANDLE)(hEvent))*/
/*#define OsResetEvent(hEvent)                    ResetEvent((HANDLE)(hEvent))*/

#define OsMemoryBarrier()                       

#ifdef WITHALIGNMENT

/* only use these inline functions for cpp code!!! */
#ifdef __cplusplus

EC_INLINE (EC_T_VOID EC_SETWORD(EC_T_VOID* ptr, EC_T_WORD val))
{
    /* little endian! LSB on [0], MSB on [1] */
    ((EC_T_BYTE*)ptr)[0] = (EC_T_BYTE)((val >>  0) & 0xFF);
    ((EC_T_BYTE*)ptr)[1] = (EC_T_BYTE)((val >>  8) & 0xFF);
}
EC_INLINE (EC_T_VOID EC_SETDWORD(EC_T_VOID* ptr, EC_T_DWORD val))
{
    /* little endian! LSB on [0], MSB on [3] */
    ((EC_T_BYTE*)ptr)[0] = (EC_T_BYTE)((val >>  0) & 0xFF);
    ((EC_T_BYTE*)ptr)[1] = (EC_T_BYTE)((val >>  8) & 0xFF);
    ((EC_T_BYTE*)ptr)[2] = (EC_T_BYTE)((val >> 16) & 0xFF);
    ((EC_T_BYTE*)ptr)[3] = (EC_T_BYTE)((val >> 24) & 0xFF);
}
EC_INLINE (EC_T_VOID EC_SETQWORD(EC_T_PVOID ptr, EC_T_UINT64 val))
{
    /* little endian! LSB on [0], MSB on [7] */
    ((EC_T_PBYTE)ptr)[0] = (EC_T_BYTE)((val >>  0) & 0xff);
    ((EC_T_PBYTE)ptr)[1] = (EC_T_BYTE)((val >>  8) & 0xff);
    ((EC_T_PBYTE)ptr)[2] = (EC_T_BYTE)((val >> 16) & 0xff);
    ((EC_T_PBYTE)ptr)[3] = (EC_T_BYTE)((val >> 24) & 0xff);
    ((EC_T_PBYTE)ptr)[4] = (EC_T_BYTE)((val >> 32) & 0xff);
    ((EC_T_PBYTE)ptr)[5] = (EC_T_BYTE)((val >> 40) & 0xff);
    ((EC_T_PBYTE)ptr)[6] = (EC_T_BYTE)((val >> 48) & 0xff);
    ((EC_T_PBYTE)ptr)[7] = (EC_T_BYTE)((val >> 56) & 0xff);
}
EC_INLINE (EC_T_WORD EC_GETWORD(EC_T_VOID* ptr))
{
EC_T_WORD wRetVal = 0;

    /* little endian! LSB on [0], MSB on [1] */
    wRetVal  |= (((EC_T_BYTE*)ptr)[0] <<  0) & 0x00FF;
    wRetVal  |= (((EC_T_BYTE*)ptr)[1] <<  8) & 0xFF00;

    return wRetVal;
}
EC_INLINE (EC_T_DWORD EC_GETDWORD(EC_T_VOID* ptr))
{
EC_T_DWORD dwRetVal = 0;

    /* little endian! LSB on [0], MSB on [3] */
    dwRetVal |= (((EC_T_BYTE*)ptr)[0] <<  0) & 0x000000FF;
    dwRetVal |= (((EC_T_BYTE*)ptr)[1] <<  8) & 0x0000FF00;
    dwRetVal |= (((EC_T_BYTE*)ptr)[2] << 16) & 0x00FF0000;
    dwRetVal |= (((EC_T_BYTE*)ptr)[3] << 24) & 0xFF000000;

    return dwRetVal;
}
EC_INLINE (EC_T_UINT64 EC_GETQWORD(EC_T_VOID* ptr))
{
    EC_T_UINT64 qwRetVal = 0;

    /* little endian! LSB on [0], MSB on [7] */
    qwRetVal |= ((EC_T_UINT64)(((EC_T_PBYTE)ptr)[0]) <<  0) & (((EC_T_UINT64)0xFF) <<  0);
    qwRetVal |= ((EC_T_UINT64)(((EC_T_PBYTE)ptr)[1]) <<  8) & (((EC_T_UINT64)0xFF) <<  8);
    qwRetVal |= ((EC_T_UINT64)(((EC_T_PBYTE)ptr)[2]) << 16) & (((EC_T_UINT64)0xFF) << 16);
    qwRetVal |= ((EC_T_UINT64)(((EC_T_PBYTE)ptr)[3]) << 24) & (((EC_T_UINT64)0xFF) << 24);
    qwRetVal |= ((EC_T_UINT64)(((EC_T_PBYTE)ptr)[4]) << 32) & (((EC_T_UINT64)0xFF) << 32);
    qwRetVal |= ((EC_T_UINT64)(((EC_T_PBYTE)ptr)[5]) << 40) & (((EC_T_UINT64)0xFF) << 40);
    qwRetVal |= ((EC_T_UINT64)(((EC_T_PBYTE)ptr)[6]) << 48) & (((EC_T_UINT64)0xFF) << 48);
    qwRetVal |= ((EC_T_UINT64)(((EC_T_PBYTE)ptr)[7]) << 56) & (((EC_T_UINT64)0xFF) << 56);

    return qwRetVal;
}
//#endif // ifdef __cplusplus

#else //__cplusplus

EC_INLINE (EC_T_WORD EC_GETWORD(EC_T_VOID* ptr))
{
EC_T_WORD wRetVal = 0;

    /* little endian! LSB on [0], MSB on [1] */
    wRetVal  |= (((EC_T_BYTE*)ptr)[0] <<  0) & 0x00FF;
    wRetVal  |= (((EC_T_BYTE*)ptr)[1] <<  8) & 0xFF00;

    return wRetVal;
}

EC_INLINE (EC_T_DWORD EC_GETDWORD(EC_T_VOID* ptr))
{
EC_T_DWORD dwRetVal = 0;

    /* little endian! LSB on [0], MSB on [3] */
    dwRetVal |= (((EC_T_BYTE*)ptr)[0] <<  0) & 0x000000FF;
    dwRetVal |= (((EC_T_BYTE*)ptr)[1] <<  8) & 0x0000FF00;
    dwRetVal |= (((EC_T_BYTE*)ptr)[2] << 16) & 0x00FF0000;
    dwRetVal |= (((EC_T_BYTE*)ptr)[3] << 24) & 0xFF000000;

    return dwRetVal;
}


EC_INLINE (EC_T_VOID EC_SETWORD(EC_T_VOID* ptr, EC_T_WORD val))
{
    /* little endian! LSB on [0], MSB on [1] */
    ((EC_T_BYTE*)ptr)[0] = (EC_T_BYTE)((val >>  0) & 0xFF);
    ((EC_T_BYTE*)ptr)[1] = (EC_T_BYTE)((val >>  8) & 0xFF);
}

EC_INLINE (EC_T_VOID EC_SETDWORD(EC_T_VOID* ptr, EC_T_DWORD val))
{
    /* little endian! LSB on [0], MSB on [3] */
    ((EC_T_BYTE*)ptr)[0] = (EC_T_BYTE)((val >>  0) & 0xFF);
    ((EC_T_BYTE*)ptr)[1] = (EC_T_BYTE)((val >>  8) & 0xFF);
    ((EC_T_BYTE*)ptr)[2] = (EC_T_BYTE)((val >> 16) & 0xFF);
    ((EC_T_BYTE*)ptr)[3] = (EC_T_BYTE)((val >> 24) & 0xFF);
}

#endif

#else
#define EC_SETWORD(ptr,  val)   ((*((EC_T_WORD*)(ptr))) = (EC_T_WORD)(val))
#define EC_SETDWORD(ptr, val)   ((*((EC_T_DWORD*)(ptr))) = (EC_T_DWORD)(val))
#define EC_SETQWORD(ptr, val)   ((*((EC_T_UINT64*)(ptr))) = (EC_T_UINT64)(val))

#define EC_GETWORD(ptr)         (*((EC_T_WORD*)(ptr)))
#define EC_GETDWORD(ptr)        (*((EC_T_DWORD*)(ptr)))
#define EC_GETQWORD(ptr)        (*((EC_T_UINT64*)(ptr)))
#endif

#define EC_MAKEWORD(hi, lo)     ((EC_T_WORD )(((EC_T_BYTE)(lo)) | ((EC_T_WORD )((EC_T_BYTE)(hi))) <<  8))
#define EC_MAKEDWORD(hi, lo)    ((EC_T_DWORD)(((EC_T_WORD)(lo)) | ((EC_T_DWORD)((EC_T_WORD)(hi))) << 16))
#define EC_MAKEQWORD(hi, lo)    ((EC_T_UINT64)(((EC_T_DWORD)(lo)) | ((EC_T_UINT64)((EC_T_DWORD)(hi))) << 32))

#define EC_LODWORD(qw)          ((EC_T_DWORD)(qw))
#define EC_HIDWORD(qw)          ((EC_T_DWORD)(((EC_T_UINT64)(qw) >> 32) & 0xFFFFFFFF))

#define EC_LOWORD(dw)           ((EC_T_WORD)(dw))
#define EC_HIWORD(dw)           ((EC_T_WORD)(((EC_T_DWORD)(dw) >> 16) & 0xFFFF))

#define EC_LOBYTE(w)            ((EC_T_BYTE)(w))
#define EC_HIBYTE(w)            ((EC_T_BYTE)(((EC_T_WORD)(w)   >>  8) &   0xFF))


/*-INLINES-------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C"
{
#endif
void* asm_memcpy(void* pvDest, const void* pvSrc, int iSize);
#if !((defined DEBUG) && (defined DO_LOCKDBG))
EC_INLINE (EC_T_VOID  OsLock(EC_T_VOID* pvLockHandle))
{
    OsDbgAssert( pvLockHandle != EC_NULL );
    if (pvLockHandle != NULL)
    {
        volatile RX_RESULT rxRes = RX_OK;

        rxRes = rX_MtxLockMutex(((OS_LOCK_DESC*)pvLockHandle)->rxHandle, RX_INFINITE);
        OsDbgAssert(RX_OK == rxRes);
    }
}
#endif

#if !((defined DEBUG) && (defined DO_LOCKDBG))
EC_INLINE (EC_T_VOID  OsUnlock(EC_T_VOID* pvLockHandle))
{
    OsDbgAssert( pvLockHandle != EC_NULL );
    if (pvLockHandle != NULL)
    {
        volatile RX_RESULT rxRes = RX_OK;
        rxRes = rX_MtxUnlockMutex(((OS_LOCK_DESC*)pvLockHandle)->rxHandle);

        OsDbgAssert( RX_OK == rxRes );
    }
}
#endif

#ifdef __cplusplus
};
#endif

#endif /* INC_ECOSPLATFORM */


/*-END OF SOURCE FILE--------------------------------------------------------*/
